	.include	'eq.s'
	.include	'externs.s'

	.text
input::
	bsr		readpad				;read joypad, buttons, keys
	move.l	joycur,d0
	btst.l	#KEY_STAR,d0
	beq.b	.90
	btst.l	#KEY_HASH,d0
	bne		restart				;Pause + Option restarts game
.90:	rts

gameinput::
	tst.b	pause_flag			;see if pause_flag is 0 (not paused)
	bne.b	.20					;only check pause button and keys if paused
	cmp.w	#PLR_EXP,player+O_DESC	;see if player object is an explosion
	beq.b	.20					;no joypad input allowed if player is an explosion
	bsr		input_joy
.20:	bsr		input_keys
.30:	bsr		input_but
.90:
	move.l	joycur,joyold
	cmp.b	#1,chtflag
	bne.b	.99
	bsr		cheating
.99:	rts

input_joy::
	move.l	joyedge,d0
	and.l	#ANY_JOY,d0			;erase all bits except joypad bits
	bne.b	.10					;use joyedge if joypad was just pressed
	move.l	joycur,d0
.10:	btst.l	#JOY_UP,d0			;d0 is joypad status, could be edge or cur
	beq.b	.20					;check down if not moving up
	bsr		plr_up
	bra.b	.30
.20:	btst.l	#JOY_DOWN,d0			;d0 is joypad status, could be edge or cur
	beq.b	.30					;check left and right next
	bsr		plr_down
.30:	btst.l	#JOY_LEFT,d0			;d0 is joypad status, could be edge or cur
	beq.b	.40					;check right if not moving left
	bsr		plr_left
	rts							;don't need to check right if moving left
.40:	btst.l	#JOY_RIGHT,d0			;d0 is joypad status, could be edge or cur
	beq.b	.80
	bsr		plr_right
.80:
	move.l	joycur,d0
	and.l	#ANY_JOY,d0
	bne.b	.90					;ship has already been loaded if joypad was pressed
	move.w	#SHIP_NEUTRAL,d2
	bsr		load_ship
.90:	rts

input_but::
	move.l	joyedge,d0
	tst.b	gameover
	bne.b	.05					;don't pause if game over message is displayed
	btst.l	#PAUSE,d0
	beq.b	.05
	eor.b	#1,pause_flag			;if pause is pressed, toggle pause mode
	tst.b	pause_flag
	beq.b	.02					;turn off pause message if not paused
	bsr		sndpause
	cmp.w	#PLR_FLASH,player+O_DESC	;see if player is flashing
	bne.b	.01					;if player is not flashing, leave him alone
	and.b	#$7F,player+O_TYPE		;make sure flashing player is displayed while game is paused
.01:	bsr		ld_pause				;turn on pause message
	bra.b	.05
.02:	or.b		#DELETE_OBJ,message+O_TYPE	;turn off pause message
	bsr		sndunpause

.05:	move.l	joyedge,d0
	move.l	joycur,d1
	tst.b	pause_flag			;see if pause_flag is 0 (not paused)
	bne		.90

	btst.l	#OPTION,d0
	beq.b	.08
	add.w	#1,spec_type
	cmp.w	#MAX_SPEC_WEAPONS,spec_type
	blt.b	.08
	clr.w	spec_type
.08:
	tst.b	gameover				;check game over flag
	beq.b	.15					;branch if game is not over
	cmp.b	#CONT_DELAY,cont_del	;short delay before you can continue
	bne.b	.12					;exit if delay is still counting
	move.l	d0,d6				;get joyedge
	and.l	#ANY_FIRE,d6
	bne		do_cont				;start the game if A, B, or C is pressed	
.12:	rts

.15:	cmp.w	#PLR_EXP,player+O_DESC
	beq		.90					;no input allowed if player is an explosion
	tst.b	levdelay				;check the delay at the beginning of a level
	bne		.90					;wait a little after level starts
	move.l	firebut,d2			;get which button fires bullet (FIRE_A, FIRE_B, FIRE_C)
	btst.l	d2,d0				;check edge
	bne.b	.20					;fire shot if pressed
	btst.l	d2,d1				;check cur
	beq.b	.30					;not being held down if =
	tst.b	shot_delay
	bne.b	.30					;don't allow another shot if fire_delay > 0
.20:
	bsr		fire_shot
.30:
	move.l	joyedge,d0
	move.l	joycur,d1
	move.l	bombbut,d2
	btst.l	d2,d0				;check edge
	bne.b	.40					;fire bomb if pressed
	btst.l	d2,d1				;check cur
	beq.b	.50					;not being held down if =
.40:
	bsr		fire_bomb
.50:
	move.l	joyedge,d0
	move.l	joycur,d1
	move.l	specbut,d2
	btst.l	d2,d0
	bne.b	.55
	btst.l	d2,d1
	beq.b	.90
.55:	tst.b	spec_delay
	bne.b	.90					;don't allow another
.60:
	lea		spec_tot,a0			;availability of special weapons
	move.w	spec_type,d3
	lsl.w	#1,d3				;weapon type * 2
	cmp.w	#0,(a0,d3.w)
	bne.b	.70
	btst.l	d2,d0				;check joy_edge
	beq.b	.90					;only make sound for joy edge so it doesn't repeat
	move.w	#BUZZER_SND,d0
	move.l	#$3FFF,d1				;middle pan value
	bsr		playsnd				;d0 = sample number, d1 = sound xpos
	bra.b	.90
.70:	subq.w	#1,(a0,d3.w)			;subtract 1 from the supply
	bsr		fire_spec				;fire special weapon
.90:	rts

cutinput::
	tst.b	cutter+O_TYPE			;see if cutter is active
	bmi.b	.90					;if not, she can't do anything
	tst.b	cutshdel				;firing delay for cutter
	bne.b	.90					;don't allow another shot if delay > 0
	move.b	#CUTR_SHOT_DELAY,cutshdel
	bsr		fire_cut				;make cutter fire a shot
.90:
	rts


cheating:
;check player 2 controller for cheating features
	bsr		readpad2
	move.l	joyedge2,d0
	btst.l	#OPTION,d0				;check for level change
	beq.b	.03
	move.b	#1,levflag				;go to next level
.03:
;check for scrolling speed changes
	move.l	joycur2,d0				;get controller status
	btst.l	#JOY_LEFT,d0
	beq.b	.05
	cmp.w	#0,scrlspd
	beq.b	.10						;leave scrlspd alone if it is 0
	subq.w	#1,scrlspd
.05:	btst.l	#JOY_RIGHT,d0
	beq.b	.10

	cmp.b	#0,levstatus				;only allow speed up if scrolling has not stopped yet
	bne.b	.10
	cmp.w	#MAX_SCROLLSPD,scrlspd
	beq.b	.10						;leave scrlspd alone if it is at maximum
	addq.w	#1,scrlspd
.10:
	btst.l	#JOY_UP,d0
	beq		.12

.12:	btst.l	#JOY_DOWN,d0
	beq		.14

.14:
	btst.l	#FIRE_B,d0
	beq.b	.20

	cmp.w	#0,scrlspdf
	beq.b	.20						;leave scrlspdf alone if it is 0
	sub.w	#1,scrlspdf
.20:	btst.l	#FIRE_A,d0
	beq.b	.30
	cmp.b	#0,levstatus				;only allow speed up if scrolling has not stopped yet
	bne.b	.30
	cmp.w	#MAX_SCROLLSPD,scrlspdf
	beq.b	.30						;leave scrlspdf alone if it is at maximum
	addq.w	#1,scrlspdf
.30:
	btst.l	#FIRE_C,d0
	beq		.33
	tst.b	gameover
	bne.b	.33
	cmp.w	#PLR_EXP,player+O_DESC
	beq.b	.33						;no input allowed if player is an explosion
	bsr		fire_spec					;fire special weapon even if you don't have any
.33:

	move.l	joyedge2,d0
	btst.l	#KEY_1,d0
	beq.b	.35
	bsr		pw_bull				;increase bullet power
.35:	move.l	joyedge2,d0
	btst.l	#KEY_2,d0
	beq.b	.40					;not pressed if =
	bsr		pw_bomb				;increase bomb power
.40:	move.l	joyedge2,d0
	btst.l	#KEY_3,d0
	beq		.45					;not pressed if =

.45:	move.l	joyedge2,d0
	btst.l	#KEY_4,d0
	beq		.50					;not pressed if =
.50:	move.l	joyedge2,d0
	btst.l	#KEY_5,d0
	beq		.55					;not pressed if =
.55:	move.l	joyedge2,d0
	btst.l	#KEY_6,d0
	beq		.60					;not pressed if =

.60:	move.l	joyedge2,d0
	btst.l	#KEY_7,d0
	beq		.65					;not pressed if =
.65:	move.l	joyedge2,d0
	btst.l	#KEY_8,d0
	beq		.70					;not pressed if =
.70:	move.l	joyedge2,d0
	btst.l	#KEY_9,d0
	beq		.75					;not pressed if =
.75:	move.l	joyedge2,d0
	btst.l	#KEY_STAR,d0
	beq		.77					;not pressed if =
	move.w	sampnum,d0
	move.w	#MAX_VOICES-1,d2		;use last voice
	move.l	#$00003FFF,d1			;use middle pan value
	bsr		playvoice
	bra.b	.80
.77:	move.l	joycur2,d0
	btst.l	#KEY_STAR,d0
	bne.b	.80
	cmp.w	#FIRST_FM,sampnum
	blt.b	.80
	move.w	#MAX_VOICES-1,d0		;if sampnum is an FM sound and key is not held down, turn sound off
	bsr		voiceoff

.80:	move.l	joyedge2,d0
	btst.l	#KEY_0,d0
	beq		.85					;not pressed if =
	add.w	#1,sampnum
	cmp.w	#TOTAL_SOUNDS,sampnum
	blt.b	.85
	clr.w	sampnum
.85:	move.l	joyedge2,d0
	btst.l	#KEY_HASH,d0
	beq		.90					;not pressed if =

	cmp.l	#0,tablestart+12
	beq.b	.88
	move.l	tablestart+12,sndsave0	;save pitch
	clr.l	tablestart+12			;turn off engine sound
	bra.b	.90
.88:	move.l	sndsave0,tablestart+12	;turn engine sound on

.90:	rts

input_keys::
	move.l	joyedge,d0
	and.l	#ANY_KEY,d0			;clear all bits except keypad bits
	beq		.90					;exit if no key was pressed
	btst.l	#KEY_1,d0
	beq.b	.05
	move.w	#MAGNET,spec_type
	bra		.45
.05:
	btst.l	#KEY_2,d0
	beq.b	.10
	move.w	#TRACER,spec_type
	bra		.45
.10:
	btst.l	#KEY_3,d0
	beq.b	.15
	move.w	#BEAM,spec_type
	bra		.45
.15:
	btst.l	#KEY_4,d0
	beq.b	.20
	move.w	#FLASH,spec_type
	bra.b	.45
.20:
	btst.l	#KEY_5,d0
	beq.b	.25
	move.w	#MISSILE,spec_type
	bra.b	.45
.25:
	btst.l	#KEY_6,d0
	beq.b	.30
	move.w	#RING,spec_type
	bra.b	.45
.30:
	btst.l	#KEY_7,d0
	beq.b	.35
	move.w	#BOLT,spec_type
	bra.b	.45
.35:
	btst.l	#KEY_8,d0
	beq.b	.40
	move.w	#SHIELD,spec_type
	bra.b	.45
.40:
	btst.l	#KEY_9,d0
	beq.b	.90
	move.w	#CUTTER,spec_type

.45:	bsr		draw_info				;redraw info bar when special weapon choice changes
	lea		specssnd,a0			;sound for selecting special weapon
	move.w	spec_type,d1
	clr.w	d0
	move.b	(a0,d1.w),d0
	move.l	#$00003FFF,d1			;use middle pan value
	bsr		playsnd				;d0 = sample, d1 = pan value
.90:	rts

do_cont::
;do this when player presses fire button to continue
	or.b		#DELETE_OBJ,message+O_TYPE	;turn off game over message
	clr.l	score				;erase score
	move.l	#$FFFFFFFF,oldscore
	bsr		erase_info			;clear info bar
	move.b	#STARTING_LIVES,lives
	bsr		draw_lives			;draw lives once
	move.l	#$FFFFFFFF,oldscore		;make sure score gets drawn when level starts

	move.b	#LEV_DELAY_TIME,levdelay	;so starting the game doesn't weapons to be fired

	clr.b	gameover				;clear game over flag
	bsr		init_plr
	move.w	#PLR_FLASH,player+O_DESC	;make player reappear and flash for a short time
	clr.b	plrflash				;reset player flash timer

	cmp.b	#1,bossmade
	bne.b	.50
	bsr		bssnd_on				;turn on boss sounds
.50:
	cmp.b	#0,levstatus
	bne.b	.90
	move.w	#SCROLL_SPEED,scrlspd
	move.w	#SCROLL_SPEEDF,scrlspdf

.90:	rts

;***********************************************************************************************
readpad::
;must set bit 8 ($100) in JOYOUT to cancel mute
	move.l	#$f0fffffc,d1		; d1 = Joypad data mask
	moveq.l	#-1,d2			; d2 = Cumulative joypad reading

	move.w	#$81fe,JOYOUT
	move.l	JOYIN,d0			; Read joypad, pause button, A button
	or.l		d1,d0			; Mask off unused bits
	ror.l	#4,d0
	and.l	d0,d2			; d2 = xxApxxxx RLDUxxxx xxxxxxxx xxxxxxxx
	move.w	#$81fd,JOYOUT
	move.l	JOYIN,d0			; Read *741 keys, B button
	or.l		d1,d0			; Mask off unused bits
	ror.l	#8,d0
	and.l	d0,d2			; d2 = xxApxxBx RLDU741* xxxxxxxx xxxxxxxx
	move.w	#$81fb,JOYOUT
	move.l	JOYIN,d0			; Read 2580 keys, C button
	or.l		d1,d0			; Mask off unused bits
	rol.l	#6,d0
	rol.l	#6,d0
	and.l	d0,d2			; d2 = xxApxxBx RLDU741* xxCxxxxx 2580xxxx
	move.w	#$81f7,JOYOUT
	move.l	JOYIN,d0			; Read 369# keys, Option button
	or.l		d1,d0			; Mask off unused bits
	rol.l	#8,d0
	and.l	d0,d2			; d2 = xxAPxxBx RLDU741* xxCxxxOx 2580369#

	moveq.l	#-1,d1
	eor.l	d2,d1			; d1 = Inputs active high

	move.l	joycur,d0
	move.l	d1,joycur			; Current joypad reading
	eor.l	d1,d0			;		0 & 0 = 0
	and.l	d1,d0			;		0 & 1 = 1
							;		1 & 0 = 0
							;		1 & 1 = 1
	move.l	d0,joyedge		;joypad, buttons, keys that were just pressed
	rts

readpad2::
;must set bit 8 ($100) in JOYOUT to cancel mute
;read player 2 controller
	move.l	#$0FFFFFF3,d1		; d1 = Joypad data mask
	moveq.l	#-1,d2			; d2 = Cumulative joypad reading

	move.w	#$817f,JOYOUT
	move.l	JOYIN,d0			; Read joypad, pause button, A button
	or.l		d1,d0			; Mask off unused bits
	rol.b	#2,d0			; this is different than readpad
	ror.l	#8,d0
	and.l	d0,d2			; d2 = xxApxxxx RLDUxxxx xxxxxxxx xxxxxxxx
	move.w	#$81bf,JOYOUT
	move.l	JOYIN,d0			; Read *741 keys, B button
	or.l		d1,d0			; Mask off unused bits
	rol.b	#2,d0			; this is different than readpad
	ror.l	#8,d0
	ror.l	#4,d0			; this is different than readpad
	and.l	d0,d2			; d2 = xxApxxBx RLDU741* xxxxxxxx xxxxxxxx
	move.w	#$81df,JOYOUT
	move.l	JOYIN,d0			; Read 2580 keys, C button
	or.l		d1,d0			; Mask off unused bits
	rol.b	#2,d0			; this is different than readpad
	rol.l	#8,d0
	and.l	d0,d2			; d2 = xxApxxBx RLDU741* xxCxxxxx 2580xxxx
	move.w	#$81ef,JOYOUT
	move.l	JOYIN,d0			; Read 369# keys, Option button
	or.l		d1,d0			; Mask off unused bits
	rol.b	#2,d0			; this is different than readpad
	rol.l	#4,d0
	and.l	d0,d2			; d2 = xxAPxxBx RLDU741* xxCxxxOx 2580369#

	moveq.l	#-1,d1
	eor.l	d2,d1			; d1 = Inputs active high

	move.l	joycur2,d0
	move.l	d1,joycur2		; Current joypad reading
	eor.l	d1,d0			;		0 & 0 = 0
	and.l	d1,d0			;		0 & 1 = 1
							;		1 & 0 = 0
							;		1 & 1 = 1
	move.l	d0,joyedge2		;joypad, buttons, keys that were just pressed
	rts

